/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.registration.sets;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.object.builder.v1.block.type.BlockSetTypeBuilder;
import net.fabricmc.fabric.api.object.builder.v1.block.type.WoodTypeBuilder;
import net.fabricmc.fabric.api.object.builder.v1.trade.TradeOfferHelper;
import net.fabricmc.fabric.api.registry.CompostingChanceRegistry;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.fabricmc.fabric.api.registry.StrippableBlockRegistry;
import net.hibiscus.naturespirit.blocks.BranchingTrunkBlock;
import net.hibiscus.naturespirit.blocks.DownwardVineBlock;
import net.hibiscus.naturespirit.blocks.DownwardsVinePlantBlock;
import net.hibiscus.naturespirit.blocks.ParticleLeavesBlock;
import net.hibiscus.naturespirit.blocks.ProjectileLeavesBlock;
import net.hibiscus.naturespirit.blocks.SandySaplingBlock;
import net.hibiscus.naturespirit.blocks.VinesLeavesBlock;
import net.hibiscus.naturespirit.registration.NSBoatTypes;
import net.hibiscus.naturespirit.registration.NSParticleTypes;
import net.hibiscus.naturespirit.registration.NSRegistryHelper;
import net.hibiscus.naturespirit.world.tree.BlueWisteriaSaplingGenerator;
import net.hibiscus.naturespirit.world.tree.OrangeMapleSaplingGenerator;
import net.hibiscus.naturespirit.world.tree.PinkWisteriaSaplingGenerator;
import net.hibiscus.naturespirit.world.tree.PurpleWisteriaSaplingGenerator;
import net.hibiscus.naturespirit.world.tree.RedMapleSaplingGenerator;
import net.hibiscus.naturespirit.world.tree.WhiteWisteriaSaplingGenerator;
import net.hibiscus.naturespirit.world.tree.YellowMapleSaplingGenerator;
import net.minecraft.class_1690;
import net.minecraft.class_1749;
import net.minecraft.class_1792;
import net.minecraft.class_1822;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2269;
import net.minecraft.class_2323;
import net.minecraft.class_2349;
import net.minecraft.class_2354;
import net.minecraft.class_2362;
import net.minecraft.class_2394;
import net.minecraft.class_2397;
import net.minecraft.class_2440;
import net.minecraft.class_2465;
import net.minecraft.class_2473;
import net.minecraft.class_2482;
import net.minecraft.class_2498;
import net.minecraft.class_2508;
import net.minecraft.class_2510;
import net.minecraft.class_2533;
import net.minecraft.class_2551;
import net.minecraft.class_2647;
import net.minecraft.class_2766;
import net.minecraft.class_2960;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_3853;
import net.minecraft.class_4719;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7706;
import net.minecraft.class_7707;
import net.minecraft.class_7713;
import net.minecraft.class_7715;
import net.minecraft.class_7924;
import net.minecraft.class_8177;

public class WoodSet {
    private final class_1935 leavesBefore;
    private final class_1935 saplingBefore;
    private final class_1935 logBefore;
    private final class_1935 signBefore;
    private final class_1935 boatBefore;
    private final class_1935 buttonBefore;
    private final List<class_2248> registeredBlocksList = new ArrayList<class_2248>();
    private final List<class_1792> registeredItemsList = new ArrayList<class_1792>();
    private final class_2960 name;
    private final class_3620 sideColor;
    private final class_3620 topColor;
    private final WoodPreset woodPreset;
    private class_8177 blockSetType;
    private class_4719 woodType;
    private class_2248 log;
    private class_2248 strippedLog;
    private class_2248 bundle;
    private class_2248 strippedBundle;
    private class_2248 wood;
    private class_2248 strippedWood;
    private class_2248 leaves;
    private class_2248 frostyLeaves;
    private class_2248 sapling;
    private class_2248 pottedSapling;
    private class_2248 redLeaves;
    private class_2248 redSapling;
    private class_2248 pottedRedSapling;
    private class_2248 orangeLeaves;
    private class_2248 orangeSapling;
    private class_2248 pottedOrangeSapling;
    private class_2248 yellowLeaves;
    private class_2248 yellowSapling;
    private class_2248 pottedYellowSapling;
    private class_2248 blueLeaves;
    private class_2248 partBlueLeaves;
    private class_2248 blueSapling;
    private class_2248 pottedBlueSapling;
    private class_2248 purpleLeaves;
    private class_2248 partPurpleLeaves;
    private class_2248 purpleSapling;
    private class_2248 pottedPurpleSapling;
    private class_2248 pinkLeaves;
    private class_2248 partPinkLeaves;
    private class_2248 pinkSapling;
    private class_2248 pottedPinkSapling;
    private class_2248 whiteLeaves;
    private class_2248 partWhiteLeaves;
    private class_2248 whiteSapling;
    private class_2248 pottedWhiteSapling;
    private class_2248 vines;
    private class_2248 vinesPlant;
    private class_2248 blueVines;
    private class_2248 purpleVines;
    private class_2248 pinkVines;
    private class_2248 whiteVines;
    private class_2248 blueVinesPlant;
    private class_2248 purpleVinesPlant;
    private class_2248 pinkVinesPlant;
    private class_2248 whiteVinesPlant;
    private class_2248 planks;
    private class_2248 stairs;
    private class_2248 slab;
    private class_2248 mosaic;
    private class_2248 mosaicStairs;
    private class_2248 mosaicSlab;
    private class_2248 fence;
    private class_2248 fenceGate;
    private class_2248 pressurePlate;
    private class_2248 button;
    private class_2248 door;
    private class_2248 trapDoor;
    private class_2248 sign;
    private class_2248 wallSign;
    private class_2248 hangingSign;
    private class_2248 hangingWallSign;
    private class_1792 signItem;
    private class_1792 hangingSignItem;
    private class_1792 boatItem;
    private class_1792 chestBoatItem;
    private class_6862<class_1792> itemLogsTag;
    private class_6862<class_2248> blockLogsTag;
    private final Supplier<class_1690.class_1692> boatTypeSupplier;
    private final class_2647 saplingGenerator;
    private final boolean hasMosaic;
    private final List<class_2248> leavesList = new ArrayList<class_2248>();
    private final List<class_2248> saplingList = new ArrayList<class_2248>();

    private void registerWood() {
        this.blockSetType = this.createBlockSetType();
        this.woodType = new WoodTypeBuilder().register(this.getNameID(), this.blockSetType);
        this.log = this.woodPreset == WoodPreset.JOSHUA ? this.createJoshuaLog() : this.createLog();
        class_2248 class_22482 = this.strippedLog = this.woodPreset == WoodPreset.JOSHUA ? this.createStrippedJoshuaLog() : this.createStrippedLog();
        if (this.woodPreset == WoodPreset.JOSHUA) {
            this.bundle = this.createBundle();
            this.strippedBundle = this.createStrippedBundle();
            StrippableBlockRegistry.register((class_2248)this.bundle, (class_2248)this.strippedBundle);
            FlammableBlockRegistry.getDefaultInstance().add(this.bundle, 5, 5);
            FlammableBlockRegistry.getDefaultInstance().add(this.strippedBundle, 5, 5);
        } else {
            StrippableBlockRegistry.register((class_2248)this.log, (class_2248)this.strippedLog);
        }
        if (this.woodPreset != WoodPreset.BAMBOO && this.woodPreset != WoodPreset.JOSHUA) {
            this.wood = this.createWood();
            this.strippedWood = this.createStrippedWood();
            StrippableBlockRegistry.register((class_2248)this.wood, (class_2248)this.strippedWood);
        }
        if (this.hasDefaultLeaves()) {
            this.leaves = this.createLeaves();
            ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40743).register(entries -> entries.addAfter(this.leavesBefore, new class_1935[]{this.leaves}));
            if (this.hasDefaultSapling()) {
                this.sapling = this.isSandy() ? this.createSandySapling(this.saplingGenerator) : this.createSapling(this.saplingGenerator);
                this.pottedSapling = this.createPottedSapling(this.sapling);
                ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40743).register(entries -> entries.addAfter(this.saplingBefore, new class_1935[]{this.sapling.method_8389()}));
                NSRegistryHelper.SaplingHashMap.put(this.getName(), new class_2248[]{this.sapling, this.pottedSapling});
                TradeOfferHelper.registerWanderingTraderOffers((int)1, factories -> factories.add(new class_3853.class_4165(this.sapling, 5, 1, 8, 1)));
            }
        }
        if (this.woodPreset == WoodPreset.FROSTABLE) {
            this.frostyLeaves = this.createLeaves("frosty_");
            this.leaves = this.createFrostableLeaves();
            ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40743).register(entries -> entries.addAfter(this.leavesBefore, new class_1935[]{this.leaves, this.frostyLeaves}));
            this.sapling = this.createSapling(this.saplingGenerator);
            this.pottedSapling = this.createPottedSapling(this.sapling);
            ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40743).register(entries -> entries.addAfter(this.saplingBefore, new class_1935[]{this.sapling.method_8389()}));
            NSRegistryHelper.SaplingHashMap.put(this.getName(), new class_2248[]{this.sapling, this.pottedSapling});
            TradeOfferHelper.registerWanderingTraderOffers((int)1, factories -> factories.add(new class_3853.class_4165(this.sapling, 5, 1, 8, 1)));
        }
        if (this.woodPreset == WoodPreset.WILLOW) {
            this.vines = this.createVines(this::getVinesPlant);
            this.vinesPlant = this.createVinesPlant(this.vines);
            this.leaves = this.createVinesLeavesBlock(this.vinesPlant, this.vines);
            ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40743).register(entries -> entries.addAfter(this.leavesBefore, new class_1935[]{this.leaves.method_8389()}));
            this.sapling = this.createSapling(this.saplingGenerator);
            this.pottedSapling = this.createPottedSapling(this.sapling);
            ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40743).register(entries -> entries.addAfter(this.saplingBefore, new class_1935[]{this.sapling.method_8389()}));
            ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40743).register(entries -> entries.addAfter((class_1935)class_2246.field_10597, new class_1935[]{this.vines.method_8389()}));
            NSRegistryHelper.SaplingHashMap.put(this.getName(), new class_2248[]{this.sapling, this.pottedSapling});
            TradeOfferHelper.registerWanderingTraderOffers((int)1, factories -> factories.add(new class_3853.class_4165(this.sapling, 5, 1, 8, 1)));
        }
        if (this.woodPreset == WoodPreset.WISTERIA) {
            this.whiteVines = this.createVines("white_", this::getWhiteVinesPlant);
            this.blueVines = this.createVines("blue_", this::getBlueVinesPlant);
            this.pinkVines = this.createVines("pink_", this::getPinkVinesPlant);
            this.purpleVines = this.createVines("purple_", this::getPurpleVinesPlant);
            this.whiteVinesPlant = this.createVinesPlant("white_", this.whiteVines);
            this.blueVinesPlant = this.createVinesPlant("blue_", this.blueVines);
            this.pinkVinesPlant = this.createVinesPlant("pink_", this.pinkVines);
            this.purpleVinesPlant = this.createVinesPlant("purple_", this.purpleVines);
            this.whiteLeaves = this.createVinesLeavesBlock("white_", this.whiteVinesPlant, this.whiteVines);
            this.blueLeaves = this.createVinesLeavesBlock("blue_", this.blueVinesPlant, this.blueVines);
            this.pinkLeaves = this.createVinesLeavesBlock("pink_", this.pinkVinesPlant, this.pinkVines);
            this.purpleLeaves = this.createVinesLeavesBlock("purple_", this.purpleVinesPlant, this.purpleVines);
            this.partWhiteLeaves = this.createVinesLeavesBlock("part_white_", this.whiteVinesPlant, this.whiteVines);
            this.partBlueLeaves = this.createVinesLeavesBlock("part_blue_", this.blueVinesPlant, this.blueVines);
            this.partPinkLeaves = this.createVinesLeavesBlock("part_pink_", this.pinkVinesPlant, this.pinkVines);
            this.partPurpleLeaves = this.createVinesLeavesBlock("part_purple_", this.purpleVinesPlant, this.purpleVines);
            this.whiteSapling = this.createSapling("white_", new WhiteWisteriaSaplingGenerator());
            this.blueSapling = this.createSapling("blue_", new BlueWisteriaSaplingGenerator());
            this.pinkSapling = this.createSapling("pink_", new PinkWisteriaSaplingGenerator());
            this.purpleSapling = this.createSapling("purple_", new PurpleWisteriaSaplingGenerator());
            this.pottedWhiteSapling = this.createPottedSapling("white_", this.whiteSapling);
            this.pottedBlueSapling = this.createPottedSapling("blue_", this.blueSapling);
            this.pottedPinkSapling = this.createPottedSapling("pink_", this.pinkSapling);
            this.pottedPurpleSapling = this.createPottedSapling("purple_", this.purpleSapling);
            ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40743).register(entries -> entries.addAfter(this.leavesBefore, new class_1935[]{this.whiteLeaves.method_8389(), this.partWhiteLeaves, this.blueLeaves, this.partBlueLeaves, this.pinkLeaves, this.partPinkLeaves, this.purpleLeaves, this.partPurpleLeaves}));
            ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40743).register(entries -> entries.addAfter((class_1935)class_2246.field_10597, new class_1935[]{this.whiteVines.method_8389()}));
            ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40743).register(entries -> entries.addAfter((class_1935)this.whiteVines, new class_1935[]{this.blueVines.method_8389()}));
            ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40743).register(entries -> entries.addAfter((class_1935)this.blueVines, new class_1935[]{this.pinkVines.method_8389()}));
            ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40743).register(entries -> entries.addAfter((class_1935)this.pinkVines, new class_1935[]{this.purpleVines.method_8389()}));
            ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40743).register(entries -> entries.addAfter(this.saplingBefore, new class_1935[]{this.whiteSapling.method_8389()}));
            ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40743).register(entries -> entries.addAfter((class_1935)this.whiteSapling, new class_1935[]{this.blueSapling.method_8389()}));
            ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40743).register(entries -> entries.addAfter((class_1935)this.blueSapling, new class_1935[]{this.pinkSapling.method_8389()}));
            ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40743).register(entries -> entries.addAfter((class_1935)this.pinkSapling, new class_1935[]{this.purpleSapling.method_8389()}));
            NSRegistryHelper.SaplingHashMap.put("white_" + this.getName(), new class_2248[]{this.whiteSapling, this.pottedWhiteSapling});
            NSRegistryHelper.SaplingHashMap.put("blue_" + this.getName(), new class_2248[]{this.blueSapling, this.pottedBlueSapling});
            NSRegistryHelper.SaplingHashMap.put("pink_" + this.getName(), new class_2248[]{this.pinkSapling, this.pottedPinkSapling});
            NSRegistryHelper.SaplingHashMap.put("purple_" + this.getName(), new class_2248[]{this.purpleSapling, this.pottedPurpleSapling});
            NSRegistryHelper.SaplingHashMap.put("part_white_" + this.getName(), new class_2248[]{this.whiteSapling, this.pottedWhiteSapling});
            NSRegistryHelper.SaplingHashMap.put("part_blue_" + this.getName(), new class_2248[]{this.blueSapling, this.pottedBlueSapling});
            NSRegistryHelper.SaplingHashMap.put("part_pink_" + this.getName(), new class_2248[]{this.pinkSapling, this.pottedPinkSapling});
            NSRegistryHelper.SaplingHashMap.put("part_purple_" + this.getName(), new class_2248[]{this.purpleSapling, this.pottedPurpleSapling});
            TradeOfferHelper.registerWanderingTraderOffers((int)1, factories -> {
                factories.add(new class_3853.class_4165(this.whiteSapling, 5, 1, 8, 1));
                factories.add(new class_3853.class_4165(this.blueSapling, 5, 1, 8, 1));
                factories.add(new class_3853.class_4165(this.purpleSapling, 5, 1, 8, 1));
                factories.add(new class_3853.class_4165(this.pinkSapling, 5, 1, 8, 1));
            });
        }
        if (this.woodPreset == WoodPreset.MAPLE) {
            this.redLeaves = this.createParticleLeaves("red_", (class_2394)NSParticleTypes.RED_MAPLE_LEAVES_PARTICLE, 100);
            this.orangeLeaves = this.createParticleLeaves("orange_", (class_2394)NSParticleTypes.ORANGE_MAPLE_LEAVES_PARTICLE, 100);
            this.yellowLeaves = this.createParticleLeaves("yellow_", (class_2394)NSParticleTypes.YELLOW_MAPLE_LEAVES_PARTICLE, 100);
            this.redSapling = this.createSapling("red_", new RedMapleSaplingGenerator());
            this.orangeSapling = this.createSapling("orange_", new OrangeMapleSaplingGenerator());
            this.yellowSapling = this.createSapling("yellow_", new YellowMapleSaplingGenerator());
            this.pottedRedSapling = this.createPottedSapling("red_", this.redSapling);
            this.pottedOrangeSapling = this.createPottedSapling("orange_", this.orangeSapling);
            this.pottedYellowSapling = this.createPottedSapling("yellow_", this.yellowSapling);
            ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40743).register(entries -> entries.addAfter(this.leavesBefore, new class_1935[]{this.redLeaves.method_8389()}));
            ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40743).register(entries -> entries.addAfter((class_1935)this.redLeaves, new class_1935[]{this.orangeLeaves.method_8389()}));
            ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40743).register(entries -> entries.addAfter((class_1935)this.orangeLeaves, new class_1935[]{this.yellowLeaves.method_8389()}));
            ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40743).register(entries -> entries.addAfter(this.saplingBefore, new class_1935[]{this.redSapling.method_8389()}));
            ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40743).register(entries -> entries.addAfter((class_1935)this.redSapling, new class_1935[]{this.orangeSapling.method_8389()}));
            ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40743).register(entries -> entries.addAfter((class_1935)this.orangeSapling, new class_1935[]{this.yellowSapling.method_8389()}));
            NSRegistryHelper.SaplingHashMap.put("red_" + this.getName(), new class_2248[]{this.redSapling, this.pottedRedSapling});
            NSRegistryHelper.SaplingHashMap.put("orange_" + this.getName(), new class_2248[]{this.orangeSapling, this.pottedOrangeSapling});
            NSRegistryHelper.SaplingHashMap.put("yellow_" + this.getName(), new class_2248[]{this.yellowSapling, this.pottedYellowSapling});
            TradeOfferHelper.registerWanderingTraderOffers((int)1, factories -> {
                factories.add(new class_3853.class_4165(this.redSapling, 5, 1, 8, 1));
                factories.add(new class_3853.class_4165(this.orangeSapling, 5, 1, 8, 1));
                factories.add(new class_3853.class_4165(this.yellowSapling, 5, 1, 8, 1));
            });
        }
        if (this.woodPreset == WoodPreset.ASPEN) {
            this.yellowLeaves = this.createLeaves("yellow_");
            ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40743).register(entries -> entries.addAfter(this.leavesBefore, new class_1935[]{this.yellowLeaves.method_8389()}));
        }
        if (this.hasMosaic()) {
            this.mosaic = this.createMosaic();
            this.mosaicStairs = this.createMosaicStairs();
            this.mosaicSlab = this.createMosaicSlab();
            FlammableBlockRegistry.getDefaultInstance().add(this.mosaic, 5, 20);
            FlammableBlockRegistry.getDefaultInstance().add(this.mosaicSlab, 5, 20);
            FlammableBlockRegistry.getDefaultInstance().add(this.mosaicStairs, 5, 20);
            FuelRegistry.INSTANCE.add((class_1935)this.mosaic, (Object)300);
            FuelRegistry.INSTANCE.add((class_1935)this.mosaicStairs, (Object)300);
            FuelRegistry.INSTANCE.add((class_1935)this.mosaicSlab, (Object)150);
        }
        this.planks = this.createPlanks();
        this.stairs = this.createStairs();
        this.slab = this.createSlab();
        this.fence = this.createFence();
        this.fenceGate = this.createFenceGate();
        this.pressurePlate = this.createPressurePlate();
        this.button = this.createButton();
        this.door = this.createDoor();
        this.trapDoor = this.createTrapDoor();
        this.sign = this.createSign();
        this.wallSign = this.createWallSign();
        this.hangingSign = this.createHangingSign();
        this.hangingWallSign = this.createWallHangingSign();
        this.signItem = this.createSignItem();
        this.hangingSignItem = this.createHangingSignItem();
        class_1690.class_1692 boatType = this.boatTypeSupplier.get();
        String boatTypeName = boatType.method_7559().replace("natures_spirit_", "");
        this.boatItem = this.createItem(boatTypeName + "_boat", (class_1792)new class_1749(false, boatType, new class_1792.class_1793().method_7889(1)));
        this.chestBoatItem = this.createItem(boatTypeName + "_chest_boat", (class_1792)new class_1749(true, boatType, new class_1792.class_1793().method_7889(1)));
        NSBoatTypes.addBoatTypeItems(boatType, this.boatItem, this.chestBoatItem);
        NSBoatTypes.setBoatTypeBaseItem(boatType, this.planks);
        NSRegistryHelper.RenderLayerHashMap.put(this.getName() + "_door", this.door);
        NSRegistryHelper.RenderLayerHashMap.put(this.getName() + "_trapdoor", this.trapDoor);
        FlammableBlockRegistry.getDefaultInstance().add(this.strippedLog, 5, 5);
        FlammableBlockRegistry.getDefaultInstance().add(this.log, 5, 5);
        FlammableBlockRegistry.getDefaultInstance().add(this.stairs, 5, 20);
        FlammableBlockRegistry.getDefaultInstance().add(this.slab, 5, 20);
        FlammableBlockRegistry.getDefaultInstance().add(this.planks, 5, 20);
        FlammableBlockRegistry.getDefaultInstance().add(this.fence, 5, 20);
        FlammableBlockRegistry.getDefaultInstance().add(this.fenceGate, 5, 20);
        FuelRegistry.INSTANCE.add((class_1935)this.fence, (Object)300);
        FuelRegistry.INSTANCE.add((class_1935)this.fenceGate, (Object)300);
        this.blockLogsTag = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)new class_2960(this.getModID(), this.getName() + "_logs"));
        this.itemLogsTag = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960(this.getModID(), this.getName() + "_logs"));
        WoodSet.addToBuildingTab(this.buttonBefore, this.logBefore, this.signBefore, this.boatBefore, this);
    }

    public WoodSet(class_2960 name, class_3620 sideColor, class_3620 topColor, class_1935 leavesBefore, class_1935 logBefore, class_1935 signBefore, class_1935 boatBefore, class_1935 buttonBefore, class_1935 saplingBefore, Supplier<class_1690.class_1692> boatType, WoodPreset woodPreset, boolean hasMosaic, class_2647 saplingGenerator) {
        this.woodPreset = woodPreset;
        this.name = name;
        this.sideColor = sideColor;
        this.topColor = topColor;
        this.leavesBefore = leavesBefore;
        this.logBefore = logBefore;
        this.signBefore = signBefore;
        this.boatBefore = boatBefore;
        this.buttonBefore = buttonBefore;
        this.saplingBefore = saplingBefore;
        this.boatTypeSupplier = boatType;
        this.saplingGenerator = saplingGenerator;
        this.hasMosaic = hasMosaic;
        this.registerWood();
        NSRegistryHelper.WoodHashMap.put(this.getName(), this);
    }

    public class_2960 getNameID() {
        return this.name;
    }

    public String getName() {
        return this.name.method_12832();
    }

    public String getModID() {
        return this.name.method_12836();
    }

    public class_8177 getBlockSetType() {
        return this.blockSetType;
    }

    public WoodPreset getWoodPreset() {
        return this.woodPreset;
    }

    public class_3620 getTopColor() {
        return this.topColor;
    }

    public class_4719 getWoodType() {
        return this.woodType;
    }

    public class_2248 getButton() {
        return this.button;
    }

    public class_2248 getFence() {
        return this.fence;
    }

    public class_2248 getPlanks() {
        return this.planks;
    }

    public class_2248 getSlab() {
        return this.slab;
    }

    public class_2248 getFenceGate() {
        return this.fenceGate;
    }

    public class_2248 getStairs() {
        return this.stairs;
    }

    public class_2248 getDoor() {
        return this.door;
    }

    public class_2248 getHangingSign() {
        return this.hangingSign;
    }

    public class_2248 getHangingWallSign() {
        return this.hangingWallSign;
    }

    public class_2248 getPressurePlate() {
        return this.pressurePlate;
    }

    public class_2248 getSign() {
        return this.sign;
    }

    public class_2248 getTrapDoor() {
        return this.trapDoor;
    }

    public class_2248 getWallSign() {
        return this.wallSign;
    }

    public class_1792 getHangingSignItem() {
        return this.hangingSignItem;
    }

    public class_1792 getSignItem() {
        return this.signItem;
    }

    public class_1792 getBoatItem() {
        return this.boatItem;
    }

    public class_1792 getChestBoatItem() {
        return this.chestBoatItem;
    }

    public class_2248 getLog() {
        return this.log;
    }

    public class_2248 getStrippedLog() {
        return this.strippedLog;
    }

    public class_2248 getBundle() {
        return this.bundle;
    }

    public class_2248 getStrippedBundle() {
        return this.strippedBundle;
    }

    public class_2248 getWood() {
        return this.wood;
    }

    public class_2248 getStrippedWood() {
        return this.strippedWood;
    }

    public class_2248 getMosaic() {
        return this.mosaic;
    }

    public class_2248 getMosaicStairs() {
        return this.mosaicStairs;
    }

    public class_2248 getMosaicSlab() {
        return this.mosaicSlab;
    }

    public class_2248 getLeaves() {
        return this.leaves;
    }

    public class_2248 getFrostyLeaves() {
        return this.frostyLeaves;
    }

    public class_2248 getSapling() {
        return this.sapling;
    }

    public class_2248 getPottedSapling() {
        return this.pottedSapling;
    }

    public class_2248 getVines() {
        return this.vines;
    }

    public class_2248 getVinesPlant() {
        return this.vinesPlant;
    }

    public class_2248 getRedLeaves() {
        return this.redLeaves;
    }

    public class_2248 getOrangeLeaves() {
        return this.orangeLeaves;
    }

    public class_2248 getYellowLeaves() {
        return this.yellowLeaves;
    }

    public class_2248 getBlueLeaves() {
        return this.blueLeaves;
    }

    public class_2248 getPurpleLeaves() {
        return this.purpleLeaves;
    }

    public class_2248 getPinkLeaves() {
        return this.pinkLeaves;
    }

    public class_2248 getWhiteLeaves() {
        return this.whiteLeaves;
    }

    public class_2248 getPottedRedSapling() {
        return this.pottedRedSapling;
    }

    public class_2248 getPottedOrangeSapling() {
        return this.pottedOrangeSapling;
    }

    public class_2248 getPottedYellowSapling() {
        return this.pottedYellowSapling;
    }

    public class_2248 getPottedBlueSapling() {
        return this.pottedBlueSapling;
    }

    public class_2248 getPottedPurpleSapling() {
        return this.pottedPurpleSapling;
    }

    public class_2248 getPottedPinkSapling() {
        return this.pottedPinkSapling;
    }

    public class_2248 getPottedWhiteSapling() {
        return this.pottedWhiteSapling;
    }

    public class_2248 getRedSapling() {
        return this.redSapling;
    }

    public class_2248 getOrangeSapling() {
        return this.orangeSapling;
    }

    public class_2248 getYellowSapling() {
        return this.yellowSapling;
    }

    public class_2248 getBlueSapling() {
        return this.blueSapling;
    }

    public class_2248 getPurpleSapling() {
        return this.purpleSapling;
    }

    public class_2248 getPinkSapling() {
        return this.pinkSapling;
    }

    public class_2248 getWhiteSapling() {
        return this.whiteSapling;
    }

    public class_2248 getBlueVines() {
        return this.blueVines;
    }

    public class_2248 getPurpleVines() {
        return this.purpleVines;
    }

    public class_2248 getPinkVines() {
        return this.pinkVines;
    }

    public class_2248 getWhiteVines() {
        return this.whiteVines;
    }

    public class_2248 getBlueVinesPlant() {
        return this.blueVinesPlant;
    }

    public class_2248 getPurpleVinesPlant() {
        return this.purpleVinesPlant;
    }

    public class_2248 getPinkVinesPlant() {
        return this.pinkVinesPlant;
    }

    public class_2248 getWhiteVinesPlant() {
        return this.whiteVinesPlant;
    }

    public class_2248 getPartBlueLeaves() {
        return this.partBlueLeaves;
    }

    public class_2248 getPartPurpleLeaves() {
        return this.partPurpleLeaves;
    }

    public class_2248 getPartPinkLeaves() {
        return this.partPinkLeaves;
    }

    public class_2248 getPartWhiteLeaves() {
        return this.partWhiteLeaves;
    }

    private String getWoodName() {
        String name = this.woodPreset == WoodPreset.NETHER ? this.getName() + "_hyphae" : this.getName() + "_wood";
        return name;
    }

    private String getLogName() {
        String name = this.woodPreset == WoodPreset.BAMBOO ? this.getName() + "_block" : (this.woodPreset == WoodPreset.NETHER ? this.getName() + "_stem" : this.getName() + "_log");
        return name;
    }

    private class_2248 getBase() {
        class_2248 base = this.woodPreset == WoodPreset.BAMBOO ? class_2246.field_40294 : (this.woodPreset == WoodPreset.FANCY ? class_2246.field_42751 : (this.woodPreset == WoodPreset.NETHER ? class_2246.field_22126 : class_2246.field_10161));
        return base;
    }

    private class_2248 getSignBase() {
        class_2248 base = this.woodPreset == WoodPreset.BAMBOO ? class_2246.field_40277 : (this.woodPreset == WoodPreset.FANCY ? class_2246.field_42735 : (this.woodPreset == WoodPreset.NETHER ? class_2246.field_22104 : class_2246.field_10121));
        return base;
    }

    private class_2248 getHangingSignBase() {
        class_2248 base = this.woodPreset == WoodPreset.BAMBOO ? class_2246.field_40271 : (this.woodPreset == WoodPreset.FANCY ? class_2246.field_42738 : (this.woodPreset == WoodPreset.NETHER ? class_2246.field_40268 : class_2246.field_40262));
        return base;
    }

    public class_1690.class_1692 getBoatType() {
        return this.boatTypeSupplier.get();
    }

    public class_6862<class_1792> getItemLogsTag() {
        return this.itemLogsTag;
    }

    public class_6862<class_2248> getBlockLogsTag() {
        return this.blockLogsTag;
    }

    public List<class_2248> getRegisteredBlocksList() {
        return ImmutableList.copyOf(this.registeredBlocksList);
    }

    public List<class_1792> getRegisteredItemsList() {
        return ImmutableList.copyOf(this.registeredItemsList);
    }

    public List<class_2248> getLeavesList() {
        return ImmutableList.copyOf(this.leavesList);
    }

    public List<class_2248> getsaplingList() {
        return ImmutableList.copyOf(this.saplingList);
    }

    private class_2248 createBlockWithItem(String blockID, class_2248 block) {
        class_2248 listBlock = NSRegistryHelper.registerBlock(blockID, block);
        this.registeredBlocksList.add(listBlock);
        return listBlock;
    }

    public class_1792 createItem(String blockID, class_1792 item) {
        class_1792 listItem = NSRegistryHelper.registerItem(blockID, item);
        this.registeredItemsList.add(listItem);
        return listItem;
    }

    private class_2248 createLog() {
        return this.createBlockWithItem(this.getLogName(), (class_2248)class_2246.method_26117((class_3620)this.topColor, (class_3620)this.sideColor));
    }

    private class_2248 createStrippedLog() {
        return this.createBlockWithItem("stripped_" + this.getLogName(), (class_2248)class_2246.method_26117((class_3620)this.topColor, (class_3620)this.sideColor));
    }

    private class_2248 createBundle() {
        return this.createBlockWithItem(this.getName() + "_bundle", (class_2248)class_2246.method_26117((class_3620)this.topColor, (class_3620)this.sideColor));
    }

    private class_2248 createStrippedBundle() {
        return this.createBlockWithItem("stripped_" + this.getName() + "_bundle", (class_2248)class_2246.method_26117((class_3620)this.topColor, (class_3620)this.sideColor));
    }

    private class_2248 createJoshuaLog() {
        return this.createBlockWithItem(this.getLogName(), (class_2248)new BranchingTrunkBlock(class_4970.class_2251.method_9637().method_50013().method_31710(class_3620.field_15978).method_51368(class_2766.field_12651).method_9632(2.0f).method_9626(class_2498.field_11547)));
    }

    private class_2248 createStrippedJoshuaLog() {
        return this.createBlockWithItem("stripped_" + this.getLogName(), (class_2248)new BranchingTrunkBlock(class_4970.class_2251.method_9637().method_50013().method_31710(class_3620.field_15978).method_51368(class_2766.field_12651).method_9632(2.0f).method_9626(class_2498.field_11547)));
    }

    private class_2248 createWood() {
        return this.createBlockWithItem(this.getWoodName(), (class_2248)new class_2465(class_4970.class_2251.method_9637().method_31710(this.sideColor).method_51368(class_2766.field_12651).method_9632(2.0f).method_9626(class_2498.field_11547).method_50013()));
    }

    private class_2248 createStrippedWood() {
        return this.createBlockWithItem("stripped_" + this.getWoodName(), (class_2248)new class_2465(class_4970.class_2251.method_9637().method_31710(this.topColor).method_51368(class_2766.field_12651).method_9632(2.0f).method_9626(class_2498.field_11547).method_50013()));
    }

    private class_2248 createLeaves() {
        class_2248 block = this.createBlockWithItem(this.getName() + "_leaves", (class_2248)new class_2397(class_4970.class_2251.method_9637().method_31710(class_3620.field_16004).method_9632(0.2f).method_9640().method_9626(class_2498.field_11535).method_22488().method_26235(class_2246::method_26126).method_26243(class_2246::method_26122).method_26245(class_2246::method_26122).method_50013().method_50012(class_3619.field_15971).method_26236(class_2246::method_26122)));
        CompostingChanceRegistry.INSTANCE.add((class_1935)block, (Object)Float.valueOf(0.3f));
        FlammableBlockRegistry.getDefaultInstance().add(block, 5, 20);
        NSRegistryHelper.LeavesHashMap.put(this.getName(), block);
        this.leavesList.add(block);
        return block;
    }

    private class_2248 createLeaves(String prefix) {
        class_2248 block = this.createBlockWithItem(prefix + this.getName() + "_leaves", (class_2248)new class_2397(class_4970.class_2251.method_9637().method_31710(class_3620.field_16004).method_9632(0.2f).method_9640().method_9626(class_2498.field_11535).method_22488().method_26235(class_2246::method_26126).method_26243(class_2246::method_26122).method_26245(class_2246::method_26122).method_50013().method_50012(class_3619.field_15971).method_26236(class_2246::method_26122)));
        CompostingChanceRegistry.INSTANCE.add((class_1935)block, (Object)Float.valueOf(0.3f));
        FlammableBlockRegistry.getDefaultInstance().add(block, 5, 20);
        NSRegistryHelper.LeavesHashMap.put(prefix + this.getName(), block);
        this.leavesList.add(block);
        return block;
    }

    private class_2248 createFrostableLeaves() {
        class_2248 block = this.createBlockWithItem(this.getName() + "_leaves", (class_2248)new ProjectileLeavesBlock(class_4970.class_2251.method_9637().method_31710(class_3620.field_16004).method_9632(0.2f).method_9640().method_9626(class_2498.field_11535).method_22488().method_26235(class_2246::method_26126).method_26243(class_2246::method_26122).method_26245(class_2246::method_26122).method_50013().method_50012(class_3619.field_15971).method_26236(class_2246::method_26122), this.frostyLeaves));
        CompostingChanceRegistry.INSTANCE.add((class_1935)block, (Object)Float.valueOf(0.3f));
        FlammableBlockRegistry.getDefaultInstance().add(block, 5, 20);
        NSRegistryHelper.LeavesHashMap.put(this.getName(), block);
        this.leavesList.add(block);
        return block;
    }

    private class_2248 createFrostableLeaves(String prefix) {
        class_2248 block = this.createBlockWithItem(prefix + this.getName() + "_leaves", (class_2248)new ProjectileLeavesBlock(class_4970.class_2251.method_9637().method_31710(class_3620.field_16004).method_9632(0.2f).method_9640().method_9626(class_2498.field_11535).method_22488().method_26235(class_2246::method_26126).method_26243(class_2246::method_26122).method_26245(class_2246::method_26122).method_50013().method_50012(class_3619.field_15971).method_26236(class_2246::method_26122), this.frostyLeaves));
        CompostingChanceRegistry.INSTANCE.add((class_1935)block, (Object)Float.valueOf(0.3f));
        FlammableBlockRegistry.getDefaultInstance().add(block, 5, 20);
        NSRegistryHelper.LeavesHashMap.put(prefix + this.getName(), block);
        this.leavesList.add(block);
        return block;
    }

    private class_2248 createParticleLeaves(class_2394 particle, int chance) {
        class_2248 block = this.createBlockWithItem(this.getName() + "_leaves", (class_2248)new ParticleLeavesBlock(class_4970.class_2251.method_9637().method_31710(class_3620.field_16004).method_9632(0.2f).method_9640().method_9626(class_2498.field_11535).method_22488().method_26235(class_2246::method_26126).method_26243(class_2246::method_26122).method_26245(class_2246::method_26122).method_50013().method_50012(class_3619.field_15971).method_26236(class_2246::method_26122), particle, chance));
        CompostingChanceRegistry.INSTANCE.add((class_1935)block, (Object)Float.valueOf(0.3f));
        FlammableBlockRegistry.getDefaultInstance().add(block, 5, 20);
        NSRegistryHelper.LeavesHashMap.put(this.getName(), block);
        this.leavesList.add(block);
        return block;
    }

    private class_2248 createParticleLeaves(String prefix, class_2394 particle, int chance) {
        class_2248 block = this.createBlockWithItem(prefix + this.getName() + "_leaves", (class_2248)new ParticleLeavesBlock(class_4970.class_2251.method_9637().method_31710(class_3620.field_16004).method_9632(0.2f).method_9640().method_9626(class_2498.field_11535).method_22488().method_26235(class_2246::method_26126).method_26243(class_2246::method_26122).method_26245(class_2246::method_26122).method_50013().method_50012(class_3619.field_15971).method_26236(class_2246::method_26122), particle, chance));
        CompostingChanceRegistry.INSTANCE.add((class_1935)block, (Object)Float.valueOf(0.3f));
        FlammableBlockRegistry.getDefaultInstance().add(block, 5, 20);
        NSRegistryHelper.LeavesHashMap.put(prefix + this.getName(), block);
        this.leavesList.add(block);
        return block;
    }

    private class_2248 createVinesLeavesBlock(class_2248 vinesPlantBlock, class_2248 vinesTipBlock) {
        class_2248 block = this.createBlockWithItem(this.getName() + "_leaves", (class_2248)new VinesLeavesBlock(class_4970.class_2251.method_9637().method_9632(0.2f).method_9640().method_9626(class_2498.field_11535).method_22488().method_26235(class_2246::method_26126).method_26243(class_2246::method_26122).method_26245(class_2246::method_26122).method_50013().method_50012(class_3619.field_15971).method_26236(class_2246::method_26122), vinesPlantBlock, vinesTipBlock));
        CompostingChanceRegistry.INSTANCE.add((class_1935)block, (Object)Float.valueOf(0.3f));
        FlammableBlockRegistry.getDefaultInstance().add(block, 5, 20);
        NSRegistryHelper.LeavesHashMap.put(this.getName(), block);
        this.leavesList.add(block);
        return block;
    }

    private class_2248 createVinesLeavesBlock(String prefix, class_2248 vinesPlantBlock, class_2248 vinesTipBlock) {
        class_2248 block = this.createBlockWithItem(prefix + this.getName() + "_leaves", (class_2248)new VinesLeavesBlock(class_4970.class_2251.method_9637().method_9632(0.2f).method_9640().method_9626(class_2498.field_11535).method_22488().method_26235(class_2246::method_26126).method_26243(class_2246::method_26122).method_26245(class_2246::method_26122).method_50013().method_50012(class_3619.field_15971).method_26236(class_2246::method_26122), vinesPlantBlock, vinesTipBlock));
        CompostingChanceRegistry.INSTANCE.add((class_1935)block, (Object)Float.valueOf(0.3f));
        FlammableBlockRegistry.getDefaultInstance().add(block, 5, 20);
        NSRegistryHelper.LeavesHashMap.put(prefix + this.getName(), block);
        this.leavesList.add(block);
        return block;
    }

    private class_2248 createVines(Supplier<class_2248> vinesPlantBlock) {
        class_2248 vinesBlock = this.createBlockWithItem(this.getName() + "_vines", (class_2248)new DownwardVineBlock(class_4970.class_2251.method_9637().method_50012(class_3619.field_15971).method_9640().method_9634().method_22488().method_9618().method_9626(class_2498.field_22140), vinesPlantBlock));
        NSRegistryHelper.RenderLayerHashMap.put(this.getName() + "_vines", vinesBlock);
        CompostingChanceRegistry.INSTANCE.add((class_1935)vinesBlock, (Object)Float.valueOf(0.3f));
        return vinesBlock;
    }

    private class_2248 createVines(String prefix, Supplier<class_2248> vinesPlantBlock) {
        class_2248 vinesBlock = this.createBlockWithItem(prefix + this.getName() + "_vines", (class_2248)new DownwardVineBlock(class_4970.class_2251.method_9637().method_50012(class_3619.field_15971).method_9640().method_9634().method_22488().method_9618().method_9626(class_2498.field_22140), vinesPlantBlock));
        NSRegistryHelper.RenderLayerHashMap.put(prefix + this.getName() + "_vines", vinesBlock);
        CompostingChanceRegistry.INSTANCE.add((class_1935)vinesBlock, (Object)Float.valueOf(0.3f));
        return vinesBlock;
    }

    private class_2248 createVinesPlant(class_2248 vines) {
        class_2248 vinesPlant = NSRegistryHelper.registerBlockWithoutTab(this.getName() + "_vines_plant", (class_2248)new DownwardsVinePlantBlock(class_4970.class_2251.method_9637().method_50012(class_3619.field_15971).method_9634().method_22488().method_9618().method_9626(class_2498.field_22140).method_16228(vines), vines));
        NSRegistryHelper.RenderLayerHashMap.put(this.getName() + "_vines_plant", vinesPlant);
        return vinesPlant;
    }

    private class_2248 createVinesPlant(String prefix, class_2248 vines) {
        class_2248 vinesPlant = NSRegistryHelper.registerBlockWithoutTab(prefix + this.getName() + "_vines_plant", (class_2248)new DownwardsVinePlantBlock(class_4970.class_2251.method_9637().method_50012(class_3619.field_15971).method_9634().method_22488().method_9618().method_9626(class_2498.field_22140).method_16228(vines), vines));
        NSRegistryHelper.RenderLayerHashMap.put(prefix + this.getName() + "_vines_plant", vinesPlant);
        return vinesPlant;
    }

    private class_2248 createPlanks() {
        return this.createBlockWithItem(this.getName() + "_planks", new class_2248(class_4970.class_2251.method_9630((class_4970)this.getBase()).method_9626(this.getBlockSetType().comp_1290()).method_31710(this.getTopColor())));
    }

    private class_2248 createStairs() {
        return this.createBlockWithItem(this.getName() + "_stairs", (class_2248)new class_2510(this.getBase().method_9564(), class_4970.class_2251.method_9630((class_4970)this.getBase()).method_9626(this.getBlockSetType().comp_1290()).method_31710(this.getTopColor())));
    }

    private class_2248 createSlab() {
        return this.createBlockWithItem(this.getName() + "_slab", (class_2248)new class_2482(class_4970.class_2251.method_9630((class_4970)this.getBase()).method_9626(this.getBlockSetType().comp_1290()).method_31710(this.getTopColor())));
    }

    private class_2248 createMosaic() {
        return this.createBlockWithItem(this.getName() + "_mosaic", new class_2248(class_4970.class_2251.method_9630((class_4970)this.getBase()).method_9626(this.getBlockSetType().comp_1290()).method_31710(this.getTopColor())));
    }

    private class_2248 createMosaicStairs() {
        return this.createBlockWithItem(this.getName() + "_mosaic_stairs", (class_2248)new class_2510(this.getBase().method_9564(), class_4970.class_2251.method_9630((class_4970)this.getBase()).method_9626(this.getBlockSetType().comp_1290()).method_31710(this.getTopColor())));
    }

    private class_2248 createMosaicSlab() {
        return this.createBlockWithItem(this.getName() + "_mosaic_slab", (class_2248)new class_2482(class_4970.class_2251.method_9630((class_4970)this.getBase()).method_9626(this.getBlockSetType().comp_1290()).method_31710(this.getTopColor())));
    }

    private class_2248 createFence() {
        return this.createBlockWithItem(this.getName() + "_fence", (class_2248)new class_2354(class_4970.class_2251.method_9630((class_4970)this.getBase()).method_9626(this.getBlockSetType().comp_1290()).method_31710(this.getTopColor())));
    }

    private class_2248 createFenceGate() {
        return this.createBlockWithItem(this.getName() + "_fence_gate", (class_2248)new class_2349(class_4970.class_2251.method_9637().method_31710(this.getBase().method_26403()).method_51369().method_51368(class_2766.field_12651).method_9629(2.0f, 3.0f).method_50013(), this.getWoodType()));
    }

    private class_2248 createPressurePlate() {
        return this.createBlockWithItem(this.getName() + "_pressure_plate", (class_2248)new class_2440(class_2440.class_2441.field_11361, class_4970.class_2251.method_9637().method_31710(this.getBase().method_26403()).method_51369().method_51368(class_2766.field_12651).method_9634().method_9632(0.5f).method_50013().method_50012(class_3619.field_15971), this.getBlockSetType()));
    }

    private class_2248 createButton() {
        return this.createBlockWithItem(this.getName() + "_button", (class_2248)new class_2269(class_4970.class_2251.method_9637().method_9634().method_9632(0.5f).method_50012(class_3619.field_15971), this.getBlockSetType(), 30, true));
    }

    private class_2248 createDoor() {
        return this.createBlockWithItem(this.getName() + "_door", (class_2248)new class_2323(class_4970.class_2251.method_9630((class_4970)this.getBase()).method_9626(this.getBlockSetType().comp_1290()).method_22488().method_31710(this.getTopColor()), this.getBlockSetType()));
    }

    private class_2248 createTrapDoor() {
        return this.createBlockWithItem(this.getName() + "_trapdoor", (class_2248)new class_2533(class_4970.class_2251.method_9630((class_4970)this.getBase()).method_9626(this.getBlockSetType().comp_1290()).method_22488().method_31710(this.getTopColor()), this.getBlockSetType()));
    }

    private class_2248 createSign() {
        return NSRegistryHelper.registerBlockWithoutTab(this.getName() + "_sign", (class_2248)new class_2508(class_4970.class_2251.method_9630((class_4970)this.getSignBase()).method_31710(this.getTopColor()), this.getWoodType()));
    }

    private class_2248 createWallSign() {
        return NSRegistryHelper.registerBlockWithoutTab(this.getName() + "_wall_sign", (class_2248)new class_2551(class_4970.class_2251.method_9630((class_4970)this.getSignBase()).method_31710(this.getTopColor()).method_16228(this.sign), this.getWoodType()));
    }

    private class_2248 createHangingSign() {
        return NSRegistryHelper.registerBlockWithoutTab(this.getName() + "_hanging_sign", (class_2248)new class_7713(class_4970.class_2251.method_9630((class_4970)this.getHangingSignBase()).method_31710(this.getTopColor()), this.getWoodType()));
    }

    private class_2248 createWallHangingSign() {
        return NSRegistryHelper.registerBlockWithoutTab(this.getName() + "_wall_hanging_sign", (class_2248)new class_7715(class_4970.class_2251.method_9630((class_4970)this.getHangingSignBase()).method_31710(this.getTopColor()).method_16228(this.hangingSign), this.getWoodType()));
    }

    public class_2248 createSapling(class_2647 saplingGenerator) {
        class_2248 block = this.createBlockWithItem(this.getName() + "_sapling", (class_2248)new class_2473(saplingGenerator, class_4970.class_2251.method_9630((class_4970)class_2246.field_10217)));
        CompostingChanceRegistry.INSTANCE.add((class_1935)block, (Object)Float.valueOf(0.3f));
        NSRegistryHelper.RenderLayerHashMap.put(this.getName() + "_sapling", block);
        this.saplingList.add(block);
        return block;
    }

    public class_2248 createSandySapling(class_2647 saplingGenerator) {
        class_2248 block = this.createBlockWithItem(this.getName() + "_sapling", (class_2248)new SandySaplingBlock(saplingGenerator, class_4970.class_2251.method_9630((class_4970)class_2246.field_10217)));
        CompostingChanceRegistry.INSTANCE.add((class_1935)block, (Object)Float.valueOf(0.3f));
        NSRegistryHelper.RenderLayerHashMap.put(this.getName() + "_sapling", block);
        this.saplingList.add(block);
        return block;
    }

    public class_2248 createPottedSapling(class_2248 sapling) {
        return NSRegistryHelper.registerTransparentBlockWithoutTab("potted_" + this.getName() + "_sapling", (class_2248)new class_2362(sapling, class_4970.class_2251.method_9637().method_9618().method_22488().method_50012(class_3619.field_15971)));
    }

    public class_2248 createSapling(String prefix, class_2647 saplingGenerator) {
        class_2248 block = this.createBlockWithItem(prefix + this.getName() + "_sapling", (class_2248)new class_2473(saplingGenerator, class_4970.class_2251.method_9630((class_4970)class_2246.field_10217)));
        CompostingChanceRegistry.INSTANCE.add((class_1935)block, (Object)Float.valueOf(0.3f));
        NSRegistryHelper.RenderLayerHashMap.put(prefix + this.getName() + "_sapling", block);
        this.saplingList.add(block);
        return block;
    }

    public class_2248 createSandySapling(String prefix, class_2647 saplingGenerator) {
        class_2248 block = this.createBlockWithItem(prefix + this.getName() + "_sapling", (class_2248)new SandySaplingBlock(saplingGenerator, class_4970.class_2251.method_9630((class_4970)class_2246.field_10217)));
        CompostingChanceRegistry.INSTANCE.add((class_1935)block, (Object)Float.valueOf(0.3f));
        NSRegistryHelper.RenderLayerHashMap.put(prefix + this.getName() + "_sapling", block);
        this.saplingList.add(block);
        return block;
    }

    public class_2248 createPottedSapling(String prefix, class_2248 sapling) {
        return NSRegistryHelper.registerTransparentBlockWithoutTab("potted_" + prefix + this.getName() + "_sapling", (class_2248)new class_2362(sapling, class_4970.class_2251.method_9637().method_9618().method_22488().method_50012(class_3619.field_15971)));
    }

    private class_1792 createSignItem() {
        return this.createItem(this.getName() + "_sign", (class_1792)new class_1822(new class_1792.class_1793().method_7889(16), this.sign, this.wallSign));
    }

    private class_1792 createHangingSignItem() {
        return this.createItem(this.getName() + "_hanging_sign", (class_1792)new class_7707(this.hangingSign, this.hangingWallSign, new class_1792.class_1793().method_7889(16)));
    }

    private class_8177 createBlockSetType() {
        if (this.woodPreset == WoodPreset.BAMBOO) {
            return BlockSetTypeBuilder.copyOf((class_8177)class_8177.field_42833).register(this.getNameID());
        }
        if (this.woodPreset == WoodPreset.FANCY) {
            return BlockSetTypeBuilder.copyOf((class_8177)class_8177.field_42827).register(this.getNameID());
        }
        if (this.woodPreset == WoodPreset.NETHER) {
            return BlockSetTypeBuilder.copyOf((class_8177)class_8177.field_42830).register(this.getNameID());
        }
        return BlockSetTypeBuilder.copyOf((class_8177)class_8177.field_42823).register(this.getNameID());
    }

    public boolean isSandy() {
        return this.woodPreset == WoodPreset.JOSHUA || this.woodPreset == WoodPreset.SANDY;
    }

    public boolean hasDefaultLeaves() {
        return this.woodPreset == WoodPreset.DEFAULT || this.woodPreset == WoodPreset.WISTERIA || this.woodPreset == WoodPreset.FANCY || this.woodPreset == WoodPreset.JOSHUA || this.woodPreset == WoodPreset.NO_SAPLING || this.woodPreset == WoodPreset.SANDY || this.woodPreset == WoodPreset.ASPEN;
    }

    public boolean hasDefaultSapling() {
        return this.woodPreset != WoodPreset.NO_SAPLING && this.woodPreset != WoodPreset.WISTERIA;
    }

    public boolean hasBark() {
        return this.woodPreset != WoodPreset.JOSHUA && this.woodPreset != WoodPreset.BAMBOO;
    }

    public boolean hasMosaic() {
        return this.hasMosaic;
    }

    public static void addToBuildingTab(class_1935 proceedingItem, class_1935 logPlacement, class_1935 signPlacement, class_1935 boatPlacement, WoodSet woodset) {
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40195).register(entries -> {
            entries.addAfter(proceedingItem, new class_1935[]{woodset.getLog()});
            if (woodset.getWoodPreset() == WoodPreset.JOSHUA) {
                entries.addAfter((class_1935)woodset.getLog(), new class_1935[]{woodset.getBundle(), woodset.getStrippedLog(), woodset.getStrippedBundle(), woodset.getPlanks()});
            } else if (!woodset.hasBark()) {
                entries.addAfter((class_1935)woodset.getLog(), new class_1935[]{woodset.getStrippedLog(), woodset.getPlanks()});
            } else {
                entries.addAfter((class_1935)woodset.getLog(), new class_1935[]{woodset.getWood()});
                entries.addAfter((class_1935)woodset.getWood(), new class_1935[]{woodset.getStrippedLog(), woodset.getStrippedWood(), woodset.getPlanks()});
            }
            entries.addAfter((class_1935)woodset.getPlanks(), new class_1935[]{woodset.getStairs(), woodset.getSlab(), woodset.getFence(), woodset.getFenceGate(), woodset.getDoor(), woodset.getTrapDoor(), woodset.getPressurePlate(), woodset.getButton()});
            if (woodset.hasMosaic()) {
                entries.addAfter((class_1935)woodset.getPlanks(), new class_1935[]{woodset.getMosaic()});
                entries.addAfter((class_1935)woodset.getStairs(), new class_1935[]{woodset.getMosaicStairs()});
                entries.addAfter((class_1935)woodset.getSlab(), new class_1935[]{woodset.getMosaicSlab()});
            }
        });
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40743).register(entries -> entries.addAfter(logPlacement, new class_1935[]{woodset.getLog().method_8389()}));
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40197).register(entries -> entries.addAfter(signPlacement, new class_1935[]{woodset.getSignItem(), woodset.getHangingSignItem()}));
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_41060).register(entries -> entries.addAfter(boatPlacement, new class_1935[]{woodset.getBoatItem(), woodset.getChestBoatItem()}));
    }

    public static enum WoodPreset {
        DEFAULT,
        MAPLE,
        ASPEN,
        FROSTABLE,
        JOSHUA,
        SANDY,
        NO_SAPLING,
        WISTERIA,
        WILLOW,
        FANCY,
        NETHER,
        BAMBOO;

    }
}

